/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xregxdir.h
 *       defines for first command byte
 * -----------------------------------------------------------------*/

/*
// naming conventions
// The 16-bit register file requires commands to be grouped according to
// their related resource and function. Therefore each command consists of
// a group identifier byte, beginning with CMDG_, and a group member byte
// beginning with CMDM_
*/

#ifndef XREGXDIR_H_INCLUDED
#define XREGXDIR_H_INCLUDED


#define NO_COMMAND            0x0000
#define CMD_MERGE(group, modifier)    (bx_int16)((((bx_int16)(group)) << 8) | (modifier))

/*
// segmentation of the register file

// 00 - 0F
// segment reserved for compatibility reasons. Communication according to
// old protocol.
*/ /*
// group 10
// The members of this group do not require CAPI license
*/

#define CMDG_FREEACCESS            0x10

#define      CMDM_LOCK   0x01
#define        IN_LOCK      0
#define       OUT_LOCK      0
#define    CMDM_UNLOCK   0x02
#define      IN_UNLOCK      0
#define     OUT_UNLOCK      0

#define CMDG_SERVICES            0x11

#define CMDG_PERFACTION_LOCK            0x20
#define CMDG_PERFACTION_NOLOCK          0x21

#endif



